<?php
// File untuk mengecek struktur tabel inventory
require_once __DIR__ . '/../DataBase/koneksi.php';

echo "<h2>Cek Struktur Tabel Inventory</h2>";
echo "<hr>";

// Query untuk melihat struktur tabel
$sql = "DESCRIBE inventory";
$result = $conn->query($sql);

if ($result) {
    echo "<h3>Kolom yang ada di tabel 'inventory':</h3>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr style='background: #7AB2B2; color: white;'>
            <th>Field</th>
            <th>Type</th>
            <th>Null</th>
            <th>Key</th>
            <th>Default</th>
            <th>Extra</th>
          </tr>";
    
    $hasSpesifikasi = false;
    
    while ($row = $result->fetch_assoc()) {
        if ($row['Field'] === 'spesifikasi') {
            $hasSpesifikasi = true;
            echo "<tr style='background: #dcfce7;'>";
        } else {
            echo "<tr>";
        }
        
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    echo "<br>";
    
    if ($hasSpesifikasi) {
        echo "<div style='background: #dcfce7; border: 2px solid #86efac; padding: 20px; border-radius: 10px;'>";
        echo "<h3 style='color: #166534;'>✅ KOLOM 'spesifikasi' SUDAH ADA!</h3>";
        echo "<p>Kolom spesifikasi sudah tersedia di database. Anda bisa langsung menggunakannya.</p>";
        echo "</div>";
        
        // Cek berapa banyak data yang belum ada spesifikasi
        $checkEmpty = $conn->query("SELECT COUNT(*) as total FROM inventory WHERE spesifikasi IS NULL OR spesifikasi = ''");
        $emptyCount = $checkEmpty->fetch_assoc()['total'];
        
        echo "<br>";
        echo "<div style='background: #fff7ed; border: 2px solid #fbbf24; padding: 20px; border-radius: 10px;'>";
        echo "<h3 style='color: #92400e;'>⚠️ Ada $emptyCount barang yang belum memiliki spesifikasi</h3>";
        echo "<p>Anda bisa menambahkan spesifikasi melalui tombol kuning (➕) di tabel inventory.</p>";
        echo "</div>";
        
    } else {
        echo "<div style='background: #fee2e2; border: 2px solid #fca5a5; padding: 20px; border-radius: 10px;'>";
        echo "<h3 style='color: #991b1b;'>❌ KOLOM 'spesifikasi' BELUM ADA!</h3>";
        echo "<p>Anda perlu menambahkan kolom ini ke database. Lihat SQL query di bawah ini:</p>";
        echo "<hr>";
        echo "<h4>SQL Query untuk Menambahkan Kolom:</h4>";
        echo "<pre style='background: #1e293b; color: #10b981; padding: 15px; border-radius: 8px; overflow-x: auto;'>";
        echo "ALTER TABLE inventory ADD COLUMN spesifikasi TEXT NULL AFTER jenis_barang;";
        echo "</pre>";
        echo "<p><strong>Cara menjalankan:</strong></p>";
        echo "<ol>";
        echo "<li>Buka phpMyAdmin (biasanya di http://localhost/phpmyadmin)</li>";
        echo "<li>Pilih database inventory Anda</li>";
        echo "<li>Klik tab 'SQL'</li>";
        echo "<li>Copy-paste query di atas</li>";
        echo "<li>Klik 'Go' atau 'Jalankan'</li>";
        echo "</ol>";
        echo "</div>";
    }
    
} else {
    echo "<div style='background: #fee2e2; padding: 20px; border-radius: 10px;'>";
    echo "<h3 style='color: #991b1b;'>Error: " . $conn->error . "</h3>";
    echo "</div>";
}

echo "<br><br>";
echo "<a href='inventory_list.php' style='background: #7AB2B2; color: white; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: bold;'>← Kembali ke Inventory</a>";

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cek Database - Spesifikasi</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 40px;
            background: linear-gradient(135deg, #EEF7FF 0%, #CDE8E5 100%);
        }
        
        table {
            width: 100%;
            background: white;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        
        th {
            padding: 15px;
            text-align: left;
            font-weight: 700;
        }
        
        td {
            padding: 12px 15px;
        }
        
        tr:nth-child(even) {
            background: #f8fafc;
        }
    </style>
</head>
<body>
</body>
</html>