<?php
session_start();

// Validasi session
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
if ($userRole !== 'M' && $userRole !== 'A') {
    header("Location: ../../index.html?error=forbidden");
    exit;
}

require_once __DIR__ . '/../../DataBase/koneksi.php';

// Get ID from URL
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    header("Location: index.php?error=invalid_id");
    exit;
}

// Check if SDM exists
$queryCheck = "SELECT * FROM sdm WHERE id = $id";
$resultCheck = mysqli_query($conn, $queryCheck);

if (mysqli_num_rows($resultCheck) == 0) {
    header("Location: index.php?error=not_found");
    exit;
}

$sdmData = mysqli_fetch_assoc($resultCheck);

// Handle DELETE request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    // Delete the SDM record
    $queryDelete = "DELETE FROM sdm WHERE id = $id";
    
    if (mysqli_query($conn, $queryDelete)) {
        // Log activity (optional)
        $username = $_SESSION['username'] ?? 'Unknown';
        $logQuery = "INSERT INTO activity_log (user, action, description, timestamp) 
                     VALUES ('$username', 'DELETE', 'Menghapus SDM: {$sdmData['nama']}', NOW())";
        @mysqli_query($conn, $logQuery);
        
        // Redirect back with success message
        $redirect = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'index.php';
        // Clean redirect URL to add success parameter
        $separator = strpos($redirect, '?') !== false ? '&' : '?';
        header("Location: {$redirect}{$separator}success=deleted");
        exit;
    } else {
        $error = "Gagal menghapus data: " . mysqli_error($conn);
    }
}

mysqli_close($conn);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hapus SDM - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-teal: #7AB2B2;
            --secondary-teal: #4D869C;
            --light-mint: #CDE8E5;
            --lightest-mint: #EEF7FF;
            --bg-light: #f8fafc;
            --text-dark: #1e293b;
            --text-medium: #475569;
            --text-light: #64748b;
            --border-color: #e2e8f0;
            --red: #dc2626;
            --red-light: #fee2e2;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--bg-light);
            color: var(--text-dark);
            padding: 24px;
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .container {
            max-width: 600px;
            width: 100%;
        }

        .delete-card {
            background: white;
            border-radius: 16px;
            border: 1px solid var(--border-color);
            overflow: hidden;
            box-shadow: 0 8px 24px rgba(0,0,0,0.08);
        }

        .card-header {
            background: var(--red-light);
            padding: 32px 32px 24px;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
        }

        .warning-icon {
            width: 80px;
            height: 80px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.2);
        }

        .warning-icon i {
            font-size: 36px;
            color: var(--red);
        }

        .card-header h1 {
            font-size: 24px;
            font-weight: 800;
            color: var(--text-dark);
            margin-bottom: 8px;
        }

        .card-header p {
            color: var(--text-medium);
            font-size: 14px;
        }

        .card-body {
            padding: 32px;
        }

        .sdm-info {
            background: var(--bg-light);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 24px;
        }

        .info-row {
            display: flex;
            padding: 12px 0;
            border-bottom: 1px solid var(--border-color);
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-size: 13px;
            color: var(--text-light);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            width: 140px;
            flex-shrink: 0;
        }

        .info-value {
            font-size: 14px;
            color: var(--text-dark);
            font-weight: 600;
            flex: 1;
        }

        .warning-box {
            background: #fef2f2;
            border: 2px solid #fecaca;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 24px;
            display: flex;
            gap: 12px;
        }

        .warning-box i {
            color: var(--red);
            font-size: 20px;
            flex-shrink: 0;
            margin-top: 2px;
        }

        .warning-content {
            flex: 1;
        }

        .warning-content h3 {
            font-size: 14px;
            font-weight: 700;
            color: var(--red);
            margin-bottom: 6px;
        }

        .warning-content p {
            font-size: 13px;
            color: var(--text-medium);
            line-height: 1.5;
        }

        .warning-content ul {
            margin-top: 8px;
            padding-left: 20px;
        }

        .warning-content li {
            font-size: 13px;
            color: var(--text-medium);
            margin-bottom: 4px;
        }

        .form-actions {
            display: flex;
            gap: 12px;
            margin-top: 24px;
        }

        .btn {
            flex: 1;
            padding: 14px 24px;
            border-radius: 10px;
            font-weight: 700;
            font-size: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            cursor: pointer;
            border: none;
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .btn-cancel {
            background: white;
            color: var(--text-dark);
            border: 2px solid var(--border-color);
        }

        .btn-cancel:hover {
            background: var(--bg-light);
            border-color: var(--primary-teal);
        }

        .btn-delete {
            background: var(--red);
            color: white;
        }

        .btn-delete:hover {
            background: #b91c1c;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(220, 38, 38, 0.4);
        }

        .error-message {
            background: #fef2f2;
            border: 1px solid #fecaca;
            color: var(--red);
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        @media (max-width: 768px) {
            body { padding: 12px; }
            
            .card-header {
                padding: 24px 20px 20px;
            }

            .card-body {
                padding: 24px 20px;
            }

            .info-row {
                flex-direction: column;
                gap: 4px;
            }

            .info-label {
                width: 100%;
            }

            .form-actions {
                flex-direction: column-reverse;
            }

            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="delete-card">
            <!-- Card Header -->
            <div class="card-header">
                <div class="warning-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <h1>Konfirmasi Penghapusan</h1>
                <p>Apakah Anda yakin ingin menghapus data SDM ini?</p>
            </div>

            <!-- Card Body -->
            <div class="card-body">
                <?php if (isset($error)): ?>
                <div class="error-message">
                    <i class="fas fa-exclamation-circle"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
                <?php endif; ?>

                <!-- SDM Information -->
                <div class="sdm-info">
                    <div class="info-row">
                        <div class="info-label">NIP</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['nip'] ?? '-') ?></div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Nama</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['nama']) ?></div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Jabatan</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['jabatan'] ?? '-') ?></div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Kantor</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['kantor'] ?? '-') ?></div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Email</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['email'] ?? '-') ?></div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Status</div>
                        <div class="info-value"><?= htmlspecialchars($sdmData['status'] ?? 'Aktif') ?></div>
                    </div>
                </div>

                <!-- Warning Box -->
                <div class="warning-box">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div class="warning-content">
                        <h3>Peringatan Penting!</h3>
                        <p>Tindakan ini tidak dapat dibatalkan. Data yang dihapus meliputi:</p>
                        <ul>
                            <li>Semua informasi personal SDM</li>
                            <li>Riwayat yang terkait dengan SDM ini</li>
                            <li>Data tidak dapat dipulihkan setelah dihapus</li>
                        </ul>
                    </div>
                </div>

                <!-- Form Actions -->
                <form method="POST">
                    <div class="form-actions">
                        <a href="javascript:history.back()" class="btn btn-cancel">
                            <i class="fas fa-times"></i>
                            Batal
                        </a>
                        <button type="submit" name="confirm_delete" class="btn btn-delete">
                            <i class="fas fa-trash-alt"></i>
                            Ya, Hapus Data
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>