<?php
session_start();

// Validasi session
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
if ($userRole !== 'M' && $userRole !== 'A') {
    header("Location: ../../index.html?error=forbidden");
    exit;
}

require_once __DIR__ . '/../../DataBase/koneksi.php';

// Get ID from URL
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    header("Location: index.php?error=invalid_id");
    exit;
}

// Get SDM data
$queryGet = "SELECT * FROM sdm WHERE id = $id";
$resultGet = mysqli_query($conn, $queryGet);

if (mysqli_num_rows($resultGet) == 0) {
    header("Location: index.php?error=not_found");
    exit;
}

$sdm = mysqli_fetch_assoc($resultGet);

function getInitials($name) {
    $words = explode(' ', $name);
    if (count($words) >= 2) {
        return strtoupper(substr($words[0], 0, 1) . substr($words[1], 0, 1));
    }
    return strtoupper(substr($name, 0, 2));
}

function calculateAge($birthdate) {
    if (empty($birthdate)) return '-';
    $birth = new DateTime($birthdate);
    $today = new DateTime();
    $age = $today->diff($birth);
    return $age->y . ' tahun';
}

function formatDate($date) {
    if (empty($date)) return '-';
    $months = [
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    $d = new DateTime($date);
    return $d->format('d') . ' ' . $months[(int)$d->format('m')] . ' ' . $d->format('Y');
}

function calculateWorkDuration($startDate) {
    if (empty($startDate)) return '-';
    $start = new DateTime($startDate);
    $today = new DateTime();
    $diff = $today->diff($start);
    
    $years = $diff->y;
    $months = $diff->m;
    
    if ($years > 0 && $months > 0) {
        return $years . ' tahun ' . $months . ' bulan';
    } elseif ($years > 0) {
        return $years . ' tahun';
    } elseif ($months > 0) {
        return $months . ' bulan';
    } else {
        return $diff->d . ' hari';
    }
}

mysqli_close($conn);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail SDM - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-teal: #7AB2B2;
            --secondary-teal: #4D869C;
            --light-mint: #CDE8E5;
            --lightest-mint: #EEF7FF;
            --bg-light: #f8fafc;
            --text-dark: #1e293b;
            --text-medium: #475569;
            --text-light: #64748b;
            --border-color: #e2e8f0;
            --purple: #6366f1;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--bg-light);
            color: var(--text-dark);
            padding: 24px;
            line-height: 1.6;
        }

        .container { max-width: 1200px; margin: 0 auto; }

        /* Header */
        .page-header {
            margin-bottom: 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 16px;
        }

        .header-title h1 {
            font-size: 28px;
            font-weight: 800;
            color: var(--text-dark);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .breadcrumb {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            color: var(--text-light);
        }

        .breadcrumb a {
            color: var(--primary-teal);
            text-decoration: none;
            font-weight: 600;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .header-actions {
            display: flex;
            gap: 12px;
        }

        /* Buttons */
        .btn {
            padding: 11px 20px;
            border-radius: 10px;
            font-weight: 700;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            border: none;
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .btn-outline {
            background: white;
            color: var(--text-dark);
            border: 2px solid var(--border-color);
        }

        .btn-outline:hover {
            background: var(--bg-light);
            border-color: var(--primary-teal);
        }

        .btn-primary {
            background: var(--purple);
            color: white;
        }

        .btn-primary:hover {
            background: #4f46e5;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(99, 102, 241, 0.4);
        }

        .btn-danger {
            background: #dc2626;
            color: white;
        }

        .btn-danger:hover {
            background: #b91c1c;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(220, 38, 38, 0.4);
        }

        /* Profile Card */
        .profile-card {
            background: white;
            border-radius: 16px;
            border: 1px solid var(--border-color);
            padding: 32px;
            margin-bottom: 24px;
            display: flex;
            gap: 32px;
            align-items: flex-start;
        }

        .profile-avatar {
            width: 120px;
            height: 120px;
            border-radius: 16px;
            background: linear-gradient(135deg, var(--primary-teal), var(--secondary-teal));
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            font-weight: 800;
            color: white;
            flex-shrink: 0;
            box-shadow: 0 8px 24px rgba(122, 178, 178, 0.3);
        }

        .profile-info {
            flex: 1;
        }

        .profile-name {
            font-size: 28px;
            font-weight: 800;
            color: var(--text-dark);
            margin-bottom: 8px;
        }

        .profile-position {
            font-size: 16px;
            color: var(--text-medium);
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .profile-meta {
            display: flex;
            gap: 24px;
            flex-wrap: wrap;
            margin-top: 20px;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
        }

        .meta-item i {
            color: var(--primary-teal);
            width: 20px;
            text-align: center;
        }

        .badge {
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 700;
            display: inline-block;
        }

        .badge-success {
            background: #d1fae5;
            color: #065f46;
        }

        .badge-danger {
            background: #fee2e2;
            color: #991b1b;
        }

        /* Info Grid */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 20px;
            margin-bottom: 24px;
        }

        .info-card {
            background: white;
            border-radius: 16px;
            border: 1px solid var(--border-color);
            overflow: hidden;
        }

        .info-card-header {
            background: var(--bg-light);
            padding: 16px 20px;
            border-bottom: 1px solid var(--border-color);
        }

        .info-card-title {
            font-size: 14px;
            font-weight: 700;
            color: var(--text-dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-card-title i {
            color: var(--primary-teal);
        }

        .info-card-body {
            padding: 20px;
        }

        .info-row {
            display: flex;
            padding: 12px 0;
            border-bottom: 1px solid var(--border-color);
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-size: 13px;
            color: var(--text-light);
            font-weight: 600;
            width: 140px;
            flex-shrink: 0;
        }

        .info-value {
            font-size: 14px;
            color: var(--text-dark);
            font-weight: 500;
            flex: 1;
        }

        .info-value.empty {
            color: var(--text-light);
            font-style: italic;
        }

        /* Action Buttons */
        .action-buttons {
            background: white;
            border-radius: 16px;
            border: 1px solid var(--border-color);
            padding: 24px;
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
        }

        .action-btn {
            flex: 1;
            min-width: 200px;
            padding: 14px 20px;
            border-radius: 10px;
            font-weight: 700;
            font-size: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            cursor: pointer;
            border: 2px solid var(--border-color);
            background: white;
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);
        }

        .action-btn.phone {
            border-color: #16a34a;
            color: #16a34a;
        }

        .action-btn.phone:hover {
            background: #16a34a;
            color: white;
        }

        .action-btn.email {
            border-color: #0284c7;
            color: #0284c7;
        }

        .action-btn.email:hover {
            background: #0284c7;
            color: white;
        }

        .action-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            pointer-events: none;
        }

        /* Print Styles */
        @media print {
            body {
                background: white;
                padding: 0;
            }

            .page-header,
            .header-actions,
            .action-buttons,
            .btn {
                display: none !important;
            }

            .profile-card,
            .info-card {
                box-shadow: none;
                page-break-inside: avoid;
            }
        }

        /* Responsive */
        @media (max-width: 768px) {
            body { padding: 12px; }

            .profile-card {
                flex-direction: column;
                align-items: center;
                text-align: center;
                padding: 24px;
            }

            .profile-meta {
                flex-direction: column;
                gap: 12px;
            }

            .info-grid {
                grid-template-columns: 1fr;
            }

            .info-row {
                flex-direction: column;
                gap: 4px;
            }

            .info-label {
                width: 100%;
            }

            .action-buttons {
                flex-direction: column;
            }

            .action-btn {
                width: 100%;
                min-width: auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Page Header -->
        <div class="page-header">
            <div class="header-title">
                <h1>
                    <i class="fas fa-user-circle" style="color: var(--purple);"></i>
                    Detail SDM
                </h1>
                <div class="breadcrumb">
                    <a href="javascript:history.back()"><i class="fas fa-arrow-left"></i> Kembali</a>
                    <span>/</span>
                    <span>Detail SDM</span>
                </div>
            </div>
            <div class="header-actions">
                <a href="javascript:history.back()" class="btn btn-outline">
                    <i class="fas fa-arrow-left"></i>
                    Kembali
                </a>
                <a href="edit_sdm.php?id=<?= $id ?>" class="btn btn-primary">
                    <i class="fas fa-edit"></i>
                    Edit
                </a>
                <button onclick="window.print()" class="btn btn-outline">
                    <i class="fas fa-print"></i>
                    Print
                </button>
            </div>
        </div>

        <!-- Profile Card -->
        <div class="profile-card">
            <div class="profile-avatar">
                <?= getInitials($sdm['nama']) ?>
            </div>
            <div class="profile-info">
                <div class="profile-name"><?= htmlspecialchars($sdm['nama']) ?></div>
                <div class="profile-position">
                    <i class="fas fa-briefcase"></i>
                    <?= htmlspecialchars($sdm['jabatan'] ?? 'Tidak ada jabatan') ?>
                    <?php if (!empty($sdm['kantor'])): ?>
                    <span style="color: var(--text-light);">•</span>
                    <i class="fas fa-building"></i>
                    <?= htmlspecialchars($sdm['kantor']) ?>
                    <?php endif; ?>
                </div>
                
                <div class="profile-meta">
                    <?php if (!empty($sdm['nip'])): ?>
                    <div class="meta-item">
                        <i class="fas fa-id-card"></i>
                        <strong>NIP:</strong> <?= htmlspecialchars($sdm['nip']) ?>
                    </div>
                    <?php endif; ?>
                    
                    <div class="meta-item">
                        <i class="fas fa-circle-check"></i>
                        <strong>Status:</strong>
                        <span class="badge <?= ($sdm['status'] ?? 'Aktif') === 'Aktif' ? 'badge-success' : 'badge-danger' ?>">
                            <?= htmlspecialchars($sdm['status'] ?? 'Aktif') ?>
                        </span>
                    </div>

                    <?php if (!empty($sdm['jenis_kelamin'])): ?>
                    <div class="meta-item">
                        <i class="fas fa-venus-mars"></i>
                        <strong>Jenis Kelamin:</strong> <?= htmlspecialchars($sdm['jenis_kelamin']) ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Information Grid -->
        <div class="info-grid">
            <!-- Personal Information -->
            <div class="info-card">
                <div class="info-card-header">
                    <div class="info-card-title">
                        <i class="fas fa-user"></i>
                        Informasi Personal
                    </div>
                </div>
                <div class="info-card-body">
                    <div class="info-row">
                        <div class="info-label">Tempat Lahir</div>
                        <div class="info-value <?= empty($sdm['tempat_lahir']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['tempat_lahir']) ? htmlspecialchars($sdm['tempat_lahir']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Tanggal Lahir</div>
                        <div class="info-value <?= empty($sdm['tanggal_lahir']) ? 'empty' : '' ?>">
                            <?= formatDate($sdm['tanggal_lahir'] ?? '') ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Usia</div>
                        <div class="info-value <?= empty($sdm['tanggal_lahir']) ? 'empty' : '' ?>">
                            <?= calculateAge($sdm['tanggal_lahir'] ?? '') ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Alamat</div>
                        <div class="info-value <?= empty($sdm['alamat']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['alamat']) ? htmlspecialchars($sdm['alamat']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="info-card">
                <div class="info-card-header">
                    <div class="info-card-title">
                        <i class="fas fa-address-book"></i>
                        Informasi Kontak
                    </div>
                </div>
                <div class="info-card-body">
                    <div class="info-row">
                        <div class="info-label">Nomor HP</div>
                        <div class="info-value <?= empty($sdm['no_hp']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['no_hp']) ? htmlspecialchars($sdm['no_hp']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Email</div>
                        <div class="info-value <?= empty($sdm['email']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['email']) ? htmlspecialchars($sdm['email']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Employment Information -->
            <div class="info-card">
                <div class="info-card-header">
                    <div class="info-card-title">
                        <i class="fas fa-briefcase"></i>
                        Informasi Kepegawaian
                    </div>
                </div>
                <div class="info-card-body">
                    <div class="info-row">
                        <div class="info-label">Jabatan</div>
                        <div class="info-value <?= empty($sdm['jabatan']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['jabatan']) ? htmlspecialchars($sdm['jabatan']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Kantor</div>
                        <div class="info-value <?= empty($sdm['kantor']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['kantor']) ? htmlspecialchars($sdm['kantor']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Tanggal Masuk</div>
                        <div class="info-value <?= empty($sdm['tanggal_masuk']) ? 'empty' : '' ?>">
                            <?= formatDate($sdm['tanggal_masuk'] ?? '') ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Lama Bekerja</div>
                        <div class="info-value <?= empty($sdm['tanggal_masuk']) ? 'empty' : '' ?>">
                            <?= calculateWorkDuration($sdm['tanggal_masuk'] ?? '') ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Status</div>
                        <div class="info-value">
                            <span class="badge <?= ($sdm['status'] ?? 'Aktif') === 'Aktif' ? 'badge-success' : 'badge-danger' ?>">
                                <?= htmlspecialchars($sdm['status'] ?? 'Aktif') ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Education Information -->
            <div class="info-card">
                <div class="info-card-header">
                    <div class="info-card-title">
                        <i class="fas fa-graduation-cap"></i>
                        Informasi Pendidikan
                    </div>
                </div>
                <div class="info-card-body">
                    <div class="info-row">
                        <div class="info-label">Pendidikan Terakhir</div>
                        <div class="info-value <?= empty($sdm['pendidikan']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['pendidikan']) ? htmlspecialchars($sdm['pendidikan']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Jurusan</div>
                        <div class="info-value <?= empty($sdm['jurusan']) ? 'empty' : '' ?>">
                            <?= !empty($sdm['jurusan']) ? htmlspecialchars($sdm['jurusan']) : 'Tidak ada data' ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Action Buttons -->
        <div class="action-buttons">
            <?php if (!empty($sdm['no_hp'])): ?>
            <a href="tel:<?= htmlspecialchars($sdm['no_hp']) ?>" class="action-btn phone">
                <i class="fas fa-phone"></i>
                Telepon <?= htmlspecialchars($sdm['no_hp']) ?>
            </a>
            <?php else: ?>
            <button class="action-btn phone" disabled>
                <i class="fas fa-phone"></i>
                Nomor HP tidak tersedia
            </button>
            <?php endif; ?>

            <?php if (!empty($sdm['email'])): ?>
            <a href="mailto:<?= htmlspecialchars($sdm['email']) ?>" class="action-btn email">
                <i class="fas fa-envelope"></i>
                Email ke <?= htmlspecialchars($sdm['email']) ?>
            </a>
            <?php else: ?>
            <button class="action-btn email" disabled>
                <i class="fas fa-envelope"></i>
                Email tidak tersedia
            </button>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>