<?php
echo "<h1>🔍 DIAGNOSTIC REPORT - rencana_kerja.php</h1>";
echo "<style>
    body { font-family: monospace; background: #1e1e1e; color: #d4d4d4; padding: 20px; }
    h1, h2 { color: #4ec9b0; }
    .error { background: #f44336; color: white; padding: 10px; margin: 10px 0; }
    .success { background: #4caf50; color: white; padding: 10px; margin: 10px 0; }
    .warning { background: #ff9800; color: white; padding: 10px; margin: 10px 0; }
    .code { background: #2d2d2d; padding: 15px; margin: 10px 0; border-left: 4px solid #4ec9b0; overflow-x: auto; }
    .line-number { color: #858585; margin-right: 15px; }
    .highlight { background: #ff0000; color: white; }
    table { border-collapse: collapse; width: 100%; margin: 20px 0; }
    th, td { border: 1px solid #444; padding: 10px; text-align: left; }
    th { background: #2d2d2d; }
</style>";

$file_path = __DIR__ . '/rencana_kerja.php';

echo "<h2>📂 File Path</h2>";
echo "<div class='code'>" . htmlspecialchars($file_path) . "</div>";

if (!file_exists($file_path)) {
    echo "<div class='error'>❌ FILE NOT FOUND!</div>";
    echo "<p>Mencari di parent directory...</p>";
    
    $file_path = dirname(__DIR__) . '/admin/rencana_kerja.php';
    if (!file_exists($file_path)) {
        echo "<div class='error'>❌ STILL NOT FOUND!</div>";
        exit;
    }
}

echo "<div class='success'>✅ File ditemukan!</div>";

// Read file content
$content = file_get_contents($file_path);
$lines = file($file_path);

// Show lines 40-60
echo "<h2>📄 Lines 40-60 (Around Error Line 45)</h2>";
echo "<div class='code'>";
for ($i = 39; $i < 60 && $i < count($lines); $i++) {
    $line_num = $i + 1;
    $line_content = htmlspecialchars($lines[$i]);
    
    // Highlight line 45 and lines with 'deadline'
    $is_line_45 = ($line_num == 45);
    $has_deadline = (stripos($lines[$i], 'deadline') !== false);
    
    $class = '';
    if ($is_line_45) {
        $class = 'highlight';
        echo "<span class='$class'><strong class='line-number'>>>> $line_num</strong> $line_content</span>";
    } else if ($has_deadline) {
        echo "<span style='background: #ff5722; color: white;'><span class='line-number'>$line_num</span> $line_content</span>";
    } else {
        echo "<span class='line-number'>$line_num</span> $line_content";
    }
}
echo "</div>";

// Search for all occurrences of 'deadline' and 'tenggat_waktu'
echo "<h2>🔎 Semua Query dengan 'deadline' atau 'tenggat_waktu'</h2>";

$deadline_matches = [];
$tenggat_matches = [];

foreach ($lines as $num => $line) {
    if (stripos($line, 'deadline') !== false) {
        $deadline_matches[] = ['line' => $num + 1, 'content' => $line];
    }
    if (stripos($line, 'tenggat_waktu') !== false) {
        $tenggat_matches[] = ['line' => $num + 1, 'content' => $line];
    }
}

if (!empty($deadline_matches)) {
    echo "<div class='error'>❌ FOUND 'deadline' di " . count($deadline_matches) . " baris:</div>";
    echo "<table>";
    echo "<tr><th>Line</th><th>Content</th></tr>";
    foreach ($deadline_matches as $match) {
        echo "<tr>";
        echo "<td><strong>" . $match['line'] . "</strong></td>";
        echo "<td><code>" . htmlspecialchars($match['content']) . "</code></td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='success'>✅ Tidak ada 'deadline' ditemukan</div>";
}

if (!empty($tenggat_matches)) {
    echo "<div class='success'>✅ FOUND 'tenggat_waktu' di " . count($tenggat_matches) . " baris:</div>";
    echo "<table>";
    echo "<tr><th>Line</th><th>Content</th></tr>";
    foreach ($tenggat_matches as $match) {
        echo "<tr>";
        echo "<td><strong>" . $match['line'] . "</strong></td>";
        echo "<td><code>" . htmlspecialchars($match['content']) . "</code></td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Extract main query around line 45
echo "<h2>🎯 Query Utama (Baris 30-75)</h2>";
echo "<div class='code'>";
for ($i = 29; $i < 75 && $i < count($lines); $i++) {
    $line_num = $i + 1;
    $line_content = htmlspecialchars($lines[$i]);
    
    if (stripos($lines[$i], 'deadline') !== false) {
        echo "<span style='background: #ff0000; color: white;'><span class='line-number'>$line_num</span> $line_content</span>";
    } else {
        echo "<span class='line-number'>$line_num</span> $line_content";
    }
}
echo "</div>";

// Show fix
echo "<h2>✅ SOLUSI LENGKAP</h2>";
echo "<div class='warning'>";
echo "<h3>Ganti SEMUA yang bertuliskan 'deadline' dengan 'tenggat_waktu'</h3>";
echo "<p>Terutama di baris-baris yang ditampilkan di atas dengan background merah.</p>";
echo "</div>";

echo "<h3>Query yang BENAR (Copy-Paste):</h3>";
echo "<div class='code'>";
echo htmlspecialchars('$query = "
    SELECT 
        rk.*,
        creator.full_name AS creator_name,
        assignee.full_name AS assignee_name,
        approver.full_name AS approver_name
    FROM rencana_kerja rk
    LEFT JOIN users creator ON rk.created_by = creator.id
    LEFT JOIN users assignee ON rk.assigned_to = assignee.id
    LEFT JOIN users approver ON rk.approval_by = approver.id
    WHERE rk.is_deleted = 0 $dateFilter
    ORDER BY rk.tenggat_waktu ASC
";');
echo "</div>";

echo "<div class='warning'>";
echo "<h3>⚠️ AFTER EDIT:</h3>";
echo "<ol>";
echo "<li>Save file</li>";
echo "<li>Stop Laragon</li>";
echo "<li>Start Laragon</li>";
echo "<li>Clear browser cache (CTRL + SHIFT + R)</li>";
echo "</ol>";
echo "</div>";
?>