<?php
session_start();
require_once __DIR__ . '/../../DataBase/koneksi.php';

if (!function_exists('checkRole_old')) {
    function checkRole_old($roles) {
        if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], $roles)) {
            // JavaScript redirect untuk handle iframe
            echo '<script>
                var redirectUrl = "../../index.html";
                if (window.self !== window.top) {
                    window.top.location.href = redirectUrl;
                } else {
                    window.location.href = redirectUrl;
                }
            </script>';
            exit;
        }
    }
}
checkRole_old(['A']);

if (!function_exists('formatRupiah')) {
    function formatRupiah($angka) {
        return "Rp " . number_format($angka, 0, ',', '.');
    }
}

// STATISTIK UTAMA
$totalAset = $conn->query("SELECT COUNT(*) as total FROM inventory WHERE status='aktif'")->fetch_assoc()['total'];
$totalNilai = $conn->query("SELECT SUM(harga_perolehan) as total FROM inventory WHERE status='aktif'")->fetch_assoc()['total'] ?? 0;
$totalKantor = $conn->query("SELECT COUNT(DISTINCT kantor) as total FROM inventory WHERE status='aktif'")->fetch_assoc()['total'];
$totalKategori = $conn->query("SELECT COUNT(DISTINCT kategori) as total FROM inventory WHERE status='aktif'")->fetch_assoc()['total'];

// TOP KATEGORI (Simple)
$topKategori = [];
$result = $conn->query("SELECT kategori, COUNT(*) as jumlah FROM inventory WHERE status='aktif' AND kategori IS NOT NULL GROUP BY kategori ORDER BY jumlah DESC LIMIT 3");
while ($row = $result->fetch_assoc()) {
    $topKategori[] = $row;
}

// TOP KANTOR (Simple)
$topKantor = [];
$result = $conn->query("SELECT kantor, COUNT(*) as jumlah FROM inventory WHERE status='aktif' AND kantor IS NOT NULL GROUP BY kantor ORDER BY jumlah DESC LIMIT 3");
while ($row = $result->fetch_assoc()) {
    $topKantor[] = $row;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - ACF EDU HUB</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f8fafc;
            padding: 25px;
            color: #1e293b;
        }

        /* HEADER */
        .header {
            background: linear-gradient(135deg, #7AB2B2 0%, #4D869C 100%);
            color: white;
            padding: 40px;
            border-radius: 20px;
            margin-bottom: 30px;
            box-shadow: 0 8px 25px rgba(122, 178, 178, 0.25);
        }

        .header h1 {
            font-size: 32px;
            font-weight: 800;
            margin-bottom: 8px;
        }

        .header p {
            font-size: 16px;
            opacity: 0.95;
        }

        /* QUICK MENU */
        .quick-menu {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .menu-btn {
            background: white;
            padding: 25px 20px;
            border-radius: 15px;
            text-align: center;
            text-decoration: none;
            color: #1e293b;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .menu-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(122, 178, 178, 0.15);
            border-color: #7AB2B2;
        }

        .menu-btn i {
            font-size: 36px;
            color: #7AB2B2;
            margin-bottom: 12px;
            display: block;
        }

        .menu-btn span {
            display: block;
            font-size: 14px;
            font-weight: 600;
        }

        /* STATISTIK CARDS */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-box {
            background: white;
            padding: 25px 20px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .stat-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: var(--color);
        }

        .stat-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }

        .stat-box.blue::before { background: #3b82f6; }
        .stat-box.green::before { background: #10b981; }
        .stat-box.orange::before { background: #f59e0b; }
        .stat-box.teal::before { background: #7AB2B2; }

        .stat-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 15px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
        }

        .stat-box.blue .stat-icon {
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
        }

        .stat-box.green .stat-icon {
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
        }

        .stat-box.orange .stat-icon {
            background: rgba(245, 158, 11, 0.1);
            color: #f59e0b;
        }

        .stat-box.teal .stat-icon {
            background: rgba(122, 178, 178, 0.1);
            color: #7AB2B2;
        }

        .stat-number {
            font-size: 28px;
            font-weight: 800;
            color: #1e293b;
            line-height: 1;
            margin-bottom: 10px;
        }

        .stat-label {
            font-size: 14px;
            color: #64748b;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* INFO BOXES */
        .info-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .info-box {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .info-box h3 {
            font-size: 18px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .info-box h3 i {
            color: #7AB2B2;
            font-size: 22px;
        }

        .info-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px 0;
            border-bottom: 1px solid #f1f5f9;
        }

        .info-item:last-child {
            border-bottom: none;
        }

        .info-name {
            font-size: 15px;
            font-weight: 600;
            color: #334155;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .info-name i {
            color: #7AB2B2;
            font-size: 18px;
        }

        .info-value {
            font-size: 24px;
            font-weight: 800;
            color: #7AB2B2;
        }

        .empty-state {
            text-align: center;
            padding: 40px;
            color: #94a3b8;
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.3;
        }

        .empty-state p {
            font-size: 14px;
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            body {
                padding: 15px;
            }

            .header {
                padding: 25px;
            }

            .header h1 {
                font-size: 24px;
            }

            .quick-menu {
                grid-template-columns: repeat(2, 1fr);
            }

            .stats-container {
                grid-template-columns: 1fr;
            }

            .info-container {
                grid-template-columns: 1fr;
            }

            .stat-number {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

    <!-- HEADER -->
    <div class="header">
        <h1>Selamat Datang, <?php echo htmlspecialchars($_SESSION["nama"] ?? $_SESSION["username"] ?? 'Admin'); ?>!</h1>
        <p>Dashboard Administrator - Kelola dan Monitor Sistem Inventory ACF EDU HUB</p>
    </div>

    <!-- QUICK MENU -->
    <div class="quick-menu">
        <a href="../inventory/inventory_list.php" class="menu-btn">
            <i class="fas fa-boxes"></i>
            <span>Data Inventory</span>
        </a>
        <a href="../admin/users.php" class="menu-btn">
            <i class="fas fa-users-cog"></i>
            <span>Kelola User</span>
        </a>
        <a href="../staff/barang_masuk.php" class="menu-btn">
            <i class="fas fa-download"></i>
            <span>Barang Masuk</span>
        </a>
        <a href="../staff/barang_keluar.php" class="menu-btn">
            <i class="fas fa-upload"></i>
            <span>Barang Keluar</span>
        </a>
        <a href="../admin/laporan_admin.php" class="menu-btn">
            <i class="fas fa-file-alt"></i>
            <span>Laporan</span>
        </a>
        <a href="../inventory/cetak_label_panel.php" class="menu-btn">
            <i class="fas fa-qrcode"></i>
            <span>Cetak Label</span>
        </a>
    </div>

    <!-- STATISTIK UTAMA -->
    <div class="stats-container">
        <div class="stat-box blue">
            <div class="stat-icon">
                <i class="fas fa-boxes-stacked"></i>
            </div>
            <div class="stat-number"><?php echo number_format($totalAset); ?></div>
            <div class="stat-label">Total Aset</div>
        </div>

        <div class="stat-box green">
            <div class="stat-icon">
                <i class="fas fa-money-bill-wave"></i>
            </div>
            <div class="stat-number" style="font-size: 20px;"><?php echo formatRupiah($totalNilai); ?></div>
            <div class="stat-label">Nilai Investasi</div>
        </div>

        <div class="stat-box orange">
            <div class="stat-icon">
                <i class="fas fa-building"></i>
            </div>
            <div class="stat-number"><?php echo number_format($totalKantor); ?></div>
            <div class="stat-label">Lokasi Kantor</div>
        </div>

        <div class="stat-box teal">
            <div class="stat-icon">
                <i class="fas fa-tags"></i>
            </div>
            <div class="stat-number"><?php echo number_format($totalKategori); ?></div>
            <div class="stat-label">Kategori Aset</div>
        </div>
    </div>

    <!-- INFO DETAIL -->
    <div class="info-container">
        <!-- TOP KATEGORI -->
        <div class="info-box">
            <h3>
                <i class="fas fa-star"></i>
                Top 3 Kategori Terbanyak
            </h3>
            <?php if (count($topKategori) > 0): ?>
                <?php foreach ($topKategori as $index => $kat): ?>
                    <div class="info-item">
                        <div class="info-name">
                            <i class="fas fa-trophy" style="color: <?php echo $index === 0 ? '#f59e0b' : ($index === 1 ? '#94a3b8' : '#cd7f32'); ?>"></i>
                            <?php echo htmlspecialchars($kat['kategori']); ?>
                        </div>
                        <div class="info-value"><?php echo number_format($kat['jumlah']); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>Belum ada data kategori</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- TOP KANTOR -->
        <div class="info-box">
            <h3>
                <i class="fas fa-map-marker-alt"></i>
                Top 3 Lokasi Terbanyak
            </h3>
            <?php if (count($topKantor) > 0): ?>
                <?php foreach ($topKantor as $index => $kantor): ?>
                    <div class="info-item">
                        <div class="info-name">
                            <i class="fas fa-map-pin" style="color: <?php echo $index === 0 ? '#3b82f6' : ($index === 1 ? '#10b981' : '#7AB2B2'); ?>"></i>
                            <?php echo htmlspecialchars($kantor['kantor']); ?>
                        </div>
                        <div class="info-value"><?php echo number_format($kantor['jumlah']); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>Belum ada data lokasi</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

</body>
</html>