<?php
/**
 * Path Configuration Helper
 * Letakkan file ini di folder 'pages/'
 * 
 * Usage:
 * require_once __DIR__ . '/config_paths.php';
 */

// Define base paths
define('BASE_PATH', dirname(__DIR__)); // Root folder inventory_acf
define('PAGES_PATH', __DIR__); // pages folder
define('STAFF_PATH', __DIR__ . '/staff'); // staff folder
define('DATABASE_PATH', dirname(__DIR__) . '/DataBase'); // database folder

// Helper functions
function getStaffPath($file = '') {
    return STAFF_PATH . ($file ? '/' . $file : '');
}

function getPagesPath($file = '') {
    return PAGES_PATH . ($file ? '/' . $file : '');
}

function getDatabasePath($file = '') {
    return DATABASE_PATH . ($file ? '/' . $file : '');
}

// URL helpers (untuk href/action)
function getStaffUrl($file = '') {
    return './staff/' . $file;
}

function getPagesUrl($file = '') {
    return './' . $file;
}

function getParentUrl($file = '') {
    return '../' . $file;
}
?>