<?php
// File: pages/dashboard_piutang_system/check_files.php
// Diagnostic tool untuk cek file yang ada

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Check - Diagnostic</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        }
        h1 {
            color: #4D869C;
            margin-bottom: 30px;
            text-align: center;
        }
        .check-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            margin-bottom: 10px;
            background: #f8fafc;
            border-radius: 10px;
            border: 2px solid #e2e8f0;
        }
        .file-path {
            font-family: 'Courier New', monospace;
            color: #334155;
            font-size: 14px;
            flex: 1;
        }
        .status {
            padding: 6px 16px;
            border-radius: 6px;
            font-weight: 700;
            font-size: 14px;
        }
        .exists {
            background: #d1fae5;
            color: #065f46;
        }
        .missing {
            background: #fee2e2;
            color: #991b1b;
        }
        .info-box {
            background: #dbeafe;
            border-left: 4px solid #3b82f6;
            padding: 20px;
            border-radius: 8px;
            margin-top: 30px;
        }
        .error-box {
            background: #fee2e2;
            border-left: 4px solid #dc2626;
            padding: 20px;
            border-radius: 8px;
            margin-top: 20px;
        }
        .code {
            background: #1e293b;
            color: #e2e8f0;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            overflow-x: auto;
            margin: 10px 0;
        }
        h2 {
            color: #334155;
            margin: 30px 0 15px 0;
            font-size: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 File Structure Diagnostic</h1>
        
        <h2>📁 Current Directory</h2>
        <div class="check-item">
            <div class="file-path"><?= __DIR__ ?></div>
        </div>
        
        <h2>📄 Required Files Check</h2>
        
        <?php
        $current_dir = __DIR__;
        
        $files_to_check = [
            'index.php' => $current_dir . '/index.php',
            'api_kepatuhan.php' => $current_dir . '/api_kepatuhan.php',
            '../../config/connection.php' => dirname(dirname($current_dir)) . '/config/connection.php',
            '../../config/session.php' => dirname(dirname($current_dir)) . '/config/session.php',
        ];
        
        $missing_files = [];
        
        foreach ($files_to_check as $name => $path) {
            $exists = file_exists($path);
            if (!$exists) {
                $missing_files[] = $name;
            }
            ?>
            <div class="check-item">
                <div class="file-path">
                    <strong><?= htmlspecialchars($name) ?></strong><br>
                    <small><?= htmlspecialchars($path) ?></small>
                </div>
                <div class="status <?= $exists ? 'exists' : 'missing' ?>">
                    <?= $exists ? '✅ EXISTS' : '❌ MISSING' ?>
                </div>
            </div>
            <?php
        }
        ?>
        
        <?php if (!empty($missing_files)): ?>
        <div class="error-box">
            <h3 style="color: #991b1b; margin-bottom: 15px;">❌ Missing Files Detected!</h3>
            <p style="color: #7f1d1d; margin-bottom: 10px;">The following files are missing:</p>
            <ul style="color: #7f1d1d; margin-left: 20px;">
                <?php foreach ($missing_files as $file): ?>
                <li><code><?= htmlspecialchars($file) ?></code></li>
                <?php endforeach; ?>
            </ul>
        </div>
        
        <div class="info-box">
            <h3 style="color: #1e40af; margin-bottom: 15px;">💡 Solution</h3>
            <p style="color: #1e3a8a; margin-bottom: 10px;">
                <strong>For api_kepatuhan.php:</strong>
            </p>
            <p style="color: #1e3a8a; margin-bottom: 10px;">
                1. Make sure you have downloaded the <code>api_kepatuhan.php</code> file from Claude<br>
                2. Place it in this directory: <code><?= $current_dir ?></code><br>
                3. File should be named exactly: <code>api_kepatuhan.php</code>
            </p>
            
            <div class="code">Expected location:
D:\laragon\www\inventoryACF\pages\dashboard_piutang_system\api_kepatuhan.php</div>
        </div>
        
        <?php else: ?>
        <div class="info-box">
            <h3 style="color: #065f46; margin-bottom: 10px;">✅ All Files Found!</h3>
            <p style="color: #064e3b;">All required files are in place. The dashboard should work properly.</p>
        </div>
        <?php endif; ?>
        
        <h2>🧪 API Test</h2>
        <?php
        $api_file = $current_dir . '/api_kepatuhan.php';
        if (file_exists($api_file)):
        ?>
        <div class="info-box">
            <p style="color: #1e3a8a; margin-bottom: 10px;">
                API file exists! Try accessing it directly:
            </p>
            <a href="api_kepatuhan.php?action=get_periods" 
               style="display: inline-block; padding: 12px 24px; background: #3b82f6; color: white; text-decoration: none; border-radius: 8px; font-weight: 700;">
                🧪 Test API: Get Periods
            </a>
        </div>
        <?php else: ?>
        <div class="error-box">
            <p style="color: #991b1b;">
                Cannot test API - file does not exist yet.
            </p>
        </div>
        <?php endif; ?>
        
        <h2>📋 Directory Contents</h2>
        <div class="info-box" style="background: #f8fafc; border-left: 4px solid #64748b;">
            <p style="color: #334155; font-weight: 700; margin-bottom: 10px;">Files in current directory:</p>
            <div class="code" style="background: #f1f5f9; color: #334155;">
<?php
$files = scandir($current_dir);
foreach ($files as $file) {
    if ($file !== '.' && $file !== '..') {
        $full_path = $current_dir . '/' . $file;
        $type = is_dir($full_path) ? '[DIR]' : '[FILE]';
        echo htmlspecialchars("$type $file\n");
    }
}
?>
            </div>
        </div>
        
    </div>
</body>
</html>