<?php
/**
 * DEBUG SCRIPT - Cek Kategori yang Bermasalah
 * Upload file ini ke folder yang sama dengan api.php
 * Akses via browser: http://localhost/inventoryACF/pages/dashboard_piutang_system/debug_kategori.php
 */

// Load composer
$autoloadPath = 'D:/laragon/www/inventoryACF/vendor/autoload.php';
if (file_exists($autoloadPath)) {
    require_once $autoloadPath;
}

use PhpOffice\PhpSpreadsheet\IOFactory;

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Debug Kategori</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #f5f5f5; }
        .box { background: white; padding: 20px; margin: 10px 0; border-radius: 5px; }
        .error { color: red; font-weight: bold; }
        .success { color: green; }
        table { border-collapse: collapse; width: 100%; margin: 10px 0; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #667eea; color: white; }
        .invalid { background: #ffcccc; }
    </style>
</head>
<body>
    <h1>🔍 Debug Kategori Excel</h1>
    
    <div class="box">
        <h2>Upload File untuk Debug</h2>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="file" accept=".xlsx,.xls" required>
            <button type="submit">Debug File</button>
        </form>
    </div>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    echo '<div class="box">';
    echo '<h2>📋 Hasil Debug</h2>';
    
    try {
        $spreadsheet = IOFactory::load($_FILES['file']['tmp_name']);
        $sheet = $spreadsheet->getActiveSheet();
        $dataRows = $sheet->toArray();
        
        echo '<h3>Struktur File Excel:</h3>';
        echo '<table>';
        echo '<tr><th>Row</th><th>Col A (0)</th><th>Col B (1)</th><th>Col C (2)</th><th>Col D (3)</th><th>Col E (4)</th><th>Col F (5)</th><th>Col G (6)</th><th>Col H (7)</th><th>Col I (8)</th><th>Col J (9)</th></tr>';
        
        for ($i = 0; $i < min(10, count($dataRows)); $i++) {
            echo '<tr>';
            echo '<td><strong>Row ' . ($i + 1) . '</strong></td>';
            for ($j = 0; $j < 10; $j++) {
                $value = $dataRows[$i][$j] ?? '';
                echo '<td>' . htmlspecialchars($value) . '</td>';
            }
            echo '</tr>';
        }
        echo '</table>';
        
        echo '<h3>Validasi Kategori (Kolom J / Index 9):</h3>';
        echo '<table>';
        echo '<tr><th>Row</th><th>TA</th><th>Period</th><th>Category</th><th>Kategori (Raw)</th><th>Kategori (Clean)</th><th>Status</th></tr>';
        
        $validKategori = ['EXCELLENT', 'GOOD', 'AVERAGE', 'POOR'];
        $hasError = false;
        
        for ($i = 1; $i < count($dataRows); $i++) {
            $ta = trim((string)($dataRows[$i][1] ?? ''));
            if ($ta === '' || strtoupper($ta) === 'TOTAL') break;
            
            $period = trim((string)($dataRows[$i][2] ?? ''));
            $category = trim((string)($dataRows[$i][3] ?? ''));
            $kat_raw = trim((string)($dataRows[$i][9] ?? ''));
            $kat_clean = strtoupper(trim($kat_raw));
            
            $isValid = in_array($kat_clean, $validKategori);
            $rowClass = $isValid ? '' : 'invalid';
            
            if (!$isValid) $hasError = true;
            
            echo "<tr class='$rowClass'>";
            echo '<td>' . ($i + 1) . '</td>';
            echo '<td>' . htmlspecialchars($ta) . '</td>';
            echo '<td>' . htmlspecialchars($period) . '</td>';
            echo '<td>' . htmlspecialchars($category) . '</td>';
            echo '<td>' . htmlspecialchars($kat_raw) . '</td>';
            echo '<td>' . htmlspecialchars($kat_clean) . '</td>';
            echo '<td>' . ($isValid ? '<span class="success">✅ VALID</span>' : '<span class="error">❌ INVALID</span>') . '</td>';
            echo '</tr>';
        }
        echo '</table>';
        
        if ($hasError) {
            echo '<div class="error">';
            echo '<h3>⚠️ MASALAH DITEMUKAN!</h3>';
            echo '<p>Ada nilai kategori yang tidak valid. Hanya boleh: EXCELLENT, GOOD, AVERAGE, POOR</p>';
            echo '<p><strong>Solusi:</strong></p>';
            echo '<ol>';
            echo '<li>Perbaiki nilai kategori di file Excel</li>';
            echo '<li>Atau biarkan kolom kategori kosong (akan dihitung otomatis)</li>';
            echo '<li>Atau gunakan API yang sudah diperbaiki (akan auto-fix ke POOR)</li>';
            echo '</ol>';
            echo '</div>';
        } else {
            echo '<div class="success">';
            echo '<h3>✅ Semua kategori VALID!</h3>';
            echo '</div>';
        }
        
    } catch (Exception $e) {
        echo '<div class="error">';
        echo '<h3>❌ Error:</h3>';
        echo '<p>' . htmlspecialchars($e->getMessage()) . '</p>';
        echo '</div>';
    }
    
    echo '</div>';
}
?>

    <div class="box">
        <h2>📚 Info ENUM Kategori</h2>
        <p>Database hanya menerima nilai kategori berikut:</p>
        <ul>
            <li><strong>EXCELLENT</strong> - Capaian ≥ 100%</li>
            <li><strong>GOOD</strong> - Capaian ≥ 95%</li>
            <li><strong>AVERAGE</strong> - Capaian ≥ 85%</li>
            <li><strong>POOR</strong> - Capaian < 85%</li>
        </ul>
        <p><strong>Catatan:</strong> Nilai lain akan otomatis diubah ke POOR</p>
    </div>
</body>
</html>