<?php
// ===============================
// SESSION
// ===============================
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ===============================
// REQUIRE FILE
// ===============================
require_once __DIR__ . '/../../DataBase/koneksi.php';
require_once __DIR__ . '/../../helpers/depreciation_helper.php';

// ===============================
// VALIDASI PARAMETER
// ===============================
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: inventory_list.php');
    exit;
}

$id_inventory = (int) $_GET['id'];

// ===============================
// QUERY DATA INVENTORY
// ===============================
$query = "
    SELECT 
        i.*,
        k.nama_kategori
    FROM inventory i
    LEFT JOIN kategori k ON k.id_kategori = i.id_kategori
    WHERE i.id_inventory = ?
    LIMIT 1
";

$stmt = $conn->prepare($query);
$stmt->bind_param('i', $id_inventory);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "<h3>Data inventory tidak ditemukan.</h3>";
    exit;
}

$data = $result->fetch_assoc();

// ===============================
// HITUNG PENYUSUTAN
// ===============================
$penyusutan = hitungPenyusutan(
    $data['harga_perolehan'],
    $data['nilai_residu'],
    $data['umur_manfaat'],
    $data['tanggal_perolehan']
);

// ===============================
// BACK PAGE
// ===============================
$backPage = 'inventory_list.php';
if (!empty($_GET['from']) && preg_match('/^[a-z_]+\.php$/', $_GET['from'])) {
    $backPage = $_GET['from'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Detail Inventory</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f8fafc;
            margin: 0;
            padding: 20px;
        }
        .card {
            background: #ffffff;
            border-radius: 8px;
            padding: 24px;
            max-width: 900px;
            margin: auto;
            box-shadow: 0 4px 12px rgba(0,0,0,.08);
        }
        h2 {
            margin-top: 0;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        td {
            padding: 10px 8px;
            vertical-align: top;
        }
        td.label {
            width: 30%;
            color: #555;
            font-weight: bold;
        }
        .actions {
            margin-top: 30px;
            display: flex;
            gap: 12px;
        }
        .btn {
            padding: 10px 16px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: bold;
        }
        .btn-back {
            background: #64748b;
            color: white;
        }
        .btn-edit {
            background: #2563eb;
            color: white;
        }
    </style>
</head>
<body>

<div class="card">
    <h2>Detail Barang</h2>

    <table>
        <tr>
            <td class="label">Kode Aset</td>
            <td><?= htmlspecialchars($data['kode_aset']) ?></td>
        </tr>
        <tr>
            <td class="label">Nama Barang</td>
            <td><?= htmlspecialchars($data['nama_barang']) ?></td>
        </tr>
        <tr>
            <td class="label">Kategori</td>
            <td><?= htmlspecialchars($data['nama_kategori'] ?? '-') ?></td>
        </tr>
        <tr>
            <td class="label">Tanggal Perolehan</td>
            <td><?= htmlspecialchars($data['tanggal_perolehan']) ?></td>
        </tr>
        <tr>
            <td class="label">Harga Perolehan</td>
            <td><?= formatRupiah($data['harga_perolehan']) ?></td>
        </tr>
        <tr>
            <td class="label">Nilai Residu</td>
            <td><?= formatRupiah($data['nilai_residu']) ?></td>
        </tr>
        <tr>
            <td class="label">Umur Manfaat</td>
            <td><?= htmlspecialchars($data['umur_manfaat']) ?> tahun</td>
        </tr>
        <tr>
            <td class="label">Nilai Buku Saat Ini</td>
            <td><?= formatRupiah($penyusutan['nilai_buku']) ?></td>
        </tr>
        <tr>
            <td class="label">Penyusutan / Tahun</td>
            <td><?= formatRupiah($penyusutan['penyusutan_tahunan']) ?></td>
        </tr>
    </table>

    <div class="actions">
        <a href="<?= htmlspecialchars($backPage) ?>" class="btn btn-back">← Kembali</a>
        <a href="edit_spesifikasi.php?id=<?= $id_inventory ?>" class="btn btn-edit">Edit Spesifikasi</a>
    </div>
</div>

</body>
</html>
