<?php
session_start();

// ============================
// KONEKSI DATABASE (FIX PATH)
// ============================
require_once __DIR__ . '/../../DataBase/koneksi.php';

// ============================
// CEK LOGIN & ROLE (ADMIN)
// ============================
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
if ($userRole !== 'A') {
    header("Location: inventory_list.php?error=no_access");
    exit;
}

// ============================
// GET ID
// ============================
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header("Location: inventory_list.php?error=invalid_id");
    exit;
}

// ============================
// AMBIL DATA INVENTORY
// ============================
$sql = "SELECT * FROM inventory WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    header("Location: inventory_list.php?error=not_found");
    exit;
}

$row = $result->fetch_assoc();

// ============================
// PROSES SUBMIT FORM
// ============================
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $spesifikasi = trim($_POST['spesifikasi'] ?? '');

    if ($spesifikasi === '') {
        $error = 'Spesifikasi tidak boleh kosong!';
    } else {
        $updateSql = "UPDATE inventory SET spesifikasi = ? WHERE id = ?";
        $updateStmt = $conn->prepare($updateSql);
        $updateStmt->bind_param('si', $spesifikasi, $id);

        if ($updateStmt->execute()) {
            $success = true;
            $row['spesifikasi'] = $spesifikasi;
        } else {
            $error = 'Gagal menyimpan spesifikasi.';
        }

        $updateStmt->close();
    }
}

$stmt->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Spesifikasi - <?= htmlspecialchars($row['jenis_barang']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- STYLE TETAP (TIDAK DIUBAH) -->
</head>
<body>

<div class="container">

    <div class="header">
        <h1>
            <i class="fas fa-edit"></i>
            Edit Spesifikasi Barang
        </h1>
        <a href="inventory_list.php" class="btn-back">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            Spesifikasi berhasil disimpan!
        </div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($error) ?>
        </div>
    <?php endif; ?>

    <div class="form-card">

        <div class="item-info">
            <h3><?= htmlspecialchars($row['jenis_barang']) ?></h3>
            <span class="kode-badge">
                <?= htmlspecialchars($row['kode_aset'] ?: $row['kode_aset_auto'] ?: 'BELUM ADA KODE') ?>
            </span>
        </div>

        <form method="POST">
            <div class="form-group">
                <label class="form-label">
                    Spesifikasi Lengkap <span class="required">*</span>
                </label>

                <textarea name="spesifikasi" class="form-textarea" required><?= htmlspecialchars($row['spesifikasi'] ?? '') ?></textarea>

                <div class="form-help">
                    Sertakan merk, model, kapasitas, ukuran, warna, dll.
                </div>
            </div>

            <div class="form-actions">
                <button class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
                <a href="inventory_list.php" class="btn btn-secondary">
                    Batal
                </a>
            </div>
        </form>

    </div>
</div>

<script>
<?php if ($success): ?>
    setTimeout(() => {
        window.location.href = 'inventory_list.php';
    }, 1500);
<?php endif; ?>
</script>

</body>
</html>

<?php $conn->close(); ?>
