<?php
session_start();

// Security check
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

require_once __DIR__ . '/../DataBase/koneksi.php';

header('Content-Type: application/json');

// Get kategori_id from query string
$kategori_id = isset($_GET['kategori_id']) ? intval($_GET['kategori_id']) : 0;

if ($kategori_id <= 0) {
    echo json_encode([]);
    exit;
}

// Query jenis asset berdasarkan kategori
$sql = "SELECT id, kode_jenis, nama_jenis, prefix_huruf, deskripsi 
        FROM ref_jenis_asset 
        WHERE id_kategori = ? 
        ORDER BY prefix_huruf, nama_jenis";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $kategori_id);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = [
        'id' => $row['id'],
        'kode_jenis' => $row['kode_jenis'],
        'nama_jenis' => $row['nama_jenis'],
        'prefix_huruf' => $row['prefix_huruf'],
        'deskripsi' => $row['deskripsi']
    ];
}

echo json_encode($data);

$stmt->close();
$conn->close();
?>