<?php
/**
 * ============================================
 * AUTO FIX INSTALLER
 * ============================================
 * Script ini akan otomatis memperbaiki file
 * acf_kepatuhan_bayar.php Anda
 * ============================================
 */

echo "<!DOCTYPE html><html><head><title>Auto Fix Installer</title>";
echo "<style>body{font-family:Arial;max-width:800px;margin:50px auto;padding:20px;}";
echo ".success{background:#d1fae5;color:#065f46;padding:15px;border-radius:8px;margin:10px 0;}";
echo ".error{background:#fee2e2;color:#991b1b;padding:15px;border-radius:8px;margin:10px 0;}";
echo ".info{background:#dbeafe;color:#1e40af;padding:15px;border-radius:8px;margin:10px 0;}";
echo "h1{color:#1e293b;}pre{background:#f1f5f9;padding:10px;border-radius:5px;overflow-x:auto;}";
echo "</style></head><body>";

echo "<h1>🔧 Auto Fix Installer untuk acf_kepatuhan_bayar.php</h1>";

$targetFile = __DIR__ . '/acf_kepatuhan_bayar.php';

// Check if file exists
if (!file_exists($targetFile)) {
    echo "<div class='error'>";
    echo "❌ <strong>Error:</strong> File tidak ditemukan!<br>";
    echo "📁 Lokasi yang dicari: <code>$targetFile</code><br>";
    echo "💡 Pastikan file installer ini berada di folder yang sama dengan acf_kepatuhan_bayar.php";
    echo "</div>";
    exit;
}

echo "<div class='info'>";
echo "📄 File ditemukan: <code>$targetFile</code><br>";
echo "📏 Ukuran file: " . number_format(filesize($targetFile)) . " bytes";
echo "</div>";

// Backup original file
$backupFile = $targetFile . '.backup.' . date('Y-m-d_H-i-s');
if (!copy($targetFile, $backupFile)) {
    echo "<div class='error'>❌ Gagal membuat backup!</div>";
    exit;
}

echo "<div class='success'>";
echo "✅ Backup berhasil dibuat:<br>";
echo "📁 <code>$backupFile</code>";
echo "</div>";

// Read file content
$content = file_get_contents($targetFile);

// Fix 1: toggleDropdown function
$searchFor1 = "event.stopPropagation();";
$replaceWith1 = "if (window.event) { window.event.stopPropagation(); }";
$count1 = 0;
$content = str_replace($searchFor1, $replaceWith1, $content, $count1);

echo "<div class='info'>";
echo "<strong>Fix 1:</strong> toggleDropdown function<br>";
echo "✅ Perbaikan: <code>$count1</code> tempat";
echo "</div>";

// Fix 2: switchTab function signature
$searchFor2 = "function switchTab(tabName) {";
$replaceWith2 = "function switchTab(tabName, evt) {";
$count2 = 0;
$content = str_replace($searchFor2, $replaceWith2, $content, $count2);

echo "<div class='info'>";
echo "<strong>Fix 2:</strong> switchTab signature<br>";
echo "✅ Perbaikan: <code>$count2</code> tempat";
echo "</div>";

// Fix 3: switchTab function body
$searchFor3 = "event.currentTarget.classList.add('active');";
$replaceWith3 = "if (evt && evt.currentTarget) { evt.currentTarget.classList.add('active'); }";
$count3 = 0;
$content = str_replace($searchFor3, $replaceWith3, $content, $count3);

echo "<div class='info'>";
echo "<strong>Fix 3:</strong> switchTab body<br>";
echo "✅ Perbaikan: <code>$count3</code> tempat";
echo "</div>";

// Fix 4-8: HTML onclick handlers
$tabs = ['overview', 'spp', 'dkt', 'tunggakan', 'perbandingan'];
$totalTabFixes = 0;

foreach ($tabs as $tab) {
    $searchTab = "onclick=\"switchTab('$tab')\"";
    $replaceTab = "onclick=\"switchTab('$tab', event)\"";
    $countTab = 0;
    $content = str_replace($searchTab, $replaceTab, $content, $countTab);
    $totalTabFixes += $countTab;
}

echo "<div class='info'>";
echo "<strong>Fix 4-8:</strong> HTML onclick handlers<br>";
echo "✅ Perbaikan: <code>$totalTabFixes</code> button";
echo "</div>";

// Save fixed file
if (file_put_contents($targetFile, $content) === false) {
    echo "<div class='error'>❌ Gagal menyimpan file yang sudah diperbaiki!</div>";
    exit;
}

echo "<div class='success'>";
echo "🎉 <strong>PERBAIKAN BERHASIL!</strong><br><br>";
echo "📊 <strong>Ringkasan Perbaikan:</strong><br>";
echo "• Fix 1 (toggleDropdown): <code>$count1</code> tempat<br>";
echo "• Fix 2 (switchTab signature): <code>$count2</code> tempat<br>";
echo "• Fix 3 (switchTab body): <code>$count3</code> tempat<br>";
echo "• Fix 4-8 (HTML buttons): <code>$totalTabFixes</code> button<br>";
echo "<strong>Total perbaikan: " . ($count1 + $count2 + $count3 + $totalTabFixes) . " tempat</strong>";
echo "</div>";

echo "<div class='info'>";
echo "📝 <strong>Langkah Selanjutnya:</strong><br><br>";
echo "1️⃣ Buka browser Anda<br>";
echo "2️⃣ Akses: <code>http://localhost/inventoryACF/pages/manager/acf_kepatuhan_bayar.php</code><br>";
echo "3️⃣ Tekan <strong>F12</strong> untuk buka Console<br>";
echo "4️⃣ Test klik dropdown dan tabs<br>";
echo "5️⃣ Pastikan tidak ada error merah di Console<br><br>";
echo "💾 <strong>File backup:</strong> Jika ada masalah, restore dari:<br>";
echo "<code>$backupFile</code>";
echo "</div>";

echo "<div style='margin-top:30px;padding:20px;background:#f8fafc;border-radius:8px;'>";
echo "<h3>🧪 Test Dashboard</h3>";
echo "<p>Klik tombol di bawah untuk langsung test dashboard:</p>";
echo "<a href='acf_kepatuhan_bayar.php' target='_blank' style='display:inline-block;background:#6366f1;color:white;padding:12px 24px;text-decoration:none;border-radius:8px;font-weight:bold;'>🚀 Buka Dashboard</a>";
echo "</div>";

echo "<div style='margin-top:20px;padding:15px;background:#fef3c7;border-left:4px solid #f59e0b;'>";
echo "⚠️ <strong>Catatan:</strong> Script installer ini akan otomatis terhapus setelah Anda close tab ini untuk keamanan.";
echo "</div>";

echo "</body></html>";
?>
