<?php
session_start();

// Validasi session - Manager only
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
if ($userRole !== 'M') {
    header("Location: ../../index.html?error=forbidden");
    exit;
}

require_once __DIR__ . '/../../DataBase/koneksi.php';

// Get all inventory data
$sql = "SELECT * FROM inventory ORDER BY tanggal_perolehan ASC, id ASC";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error query: " . mysqli_error($conn));
}

// Calculate totals
$totalNilai = 0;
$dataLaporan = [];

while ($row = mysqli_fetch_assoc($result)) {
    $dataLaporan[] = $row;
    $totalNilai += $row['harga_perolehan'];
}

// Export to Excel
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="DAFTAR_INVENTORY_ACF_' . date('YmdHis') . '.xls"');
header('Cache-Control: max-age=0');

echo '<html xmlns:x="urn:schemas-microsoft-com:office:excel">';
echo '<head>';
echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
echo '<style>
    table { 
        border-collapse: collapse; 
        font-family: Calibri, Arial; 
        font-size: 11pt; 
    }
    .header { 
        background-color: #F4B840; 
        color: white; 
        font-weight: bold; 
        text-align: left; 
        font-size: 14pt; 
        padding: 10px; 
    }
    .column-header { 
        background-color: #F4B840; 
        color: white; 
        font-weight: bold; 
        text-align: center; 
        border: 1px solid black; 
        padding: 8px; 
        font-size: 10pt;
    }
    .data-cell { 
        border: 1px solid black; 
        padding: 5px; 
        vertical-align: top; 
    }
    .number { 
        text-align: center; 
    }
    .text { 
        mso-number-format:"\@"; 
    }
    .currency { 
        mso-number-format:"#,##0"; 
        text-align: right; 
    }
    .date { 
        mso-number-format:"dd\-mmm\-yy"; 
        text-align: center; 
    }
    .footer { 
        background-color: #F4B840; 
        color: white; 
        font-weight: bold; 
        padding: 8px; 
        border: 1px solid black;
    }
</style>';
echo '</head>';
echo '<body>';
echo '<table border="1" cellpadding="0" cellspacing="0">';

// Header
echo '<tr><td colspan="8" class="header">DAFTAR INVENTORY ACF</td></tr>';
echo '<tr><td colspan="8" style="height: 10px;"></td></tr>';

// Column Headers
echo '<tr>';
echo '<td class="column-header">No</td>';
echo '<td class="column-header">Tanggal Perolehan</td>';
echo '<td class="column-header">Kategori</td>';
echo '<td class="column-header">Sumber Dana</td>';
echo '<td class="column-header">Kantor</td>';
echo '<td class="column-header">Jenis Barang</td>';
echo '<td class="column-header">Jenis Inventory</td>';
echo '<td class="column-header">Harga perolehan</td>';
echo '</tr>';

// Empty row after header
echo '<tr>';
for ($i = 0; $i < 8; $i++) {
    echo '<td class="data-cell" style="height: 5px;"></td>';
}
echo '</tr>';

// Data Rows
$no = 1;
foreach ($dataLaporan as $row) {
    echo '<tr>';
    echo '<td class="data-cell number">' . $no++ . '</td>';
    
    // Format tanggal
    $tanggal = date('Y-m-d', strtotime($row['tanggal_perolehan']));
    echo '<td class="data-cell date">' . $tanggal . '</td>';
    
    echo '<td class="data-cell text">' . htmlspecialchars($row['kategori'] ?? '') . '</td>';
    echo '<td class="data-cell text">' . htmlspecialchars($row['sumber_dana'] ?? '') . '</td>';
    echo '<td class="data-cell text">' . htmlspecialchars($row['kantor'] ?? '') . '</td>';
    echo '<td class="data-cell text">' . htmlspecialchars($row['jenis_barang'] ?? '') . '</td>';
    echo '<td class="data-cell text">' . htmlspecialchars($row['jenis_inventory'] ?? '') . '</td>';
    echo '<td class="data-cell currency">' . number_format($row['harga_perolehan'], 0, ',', ',') . '</td>';
    echo '</tr>';
}

// Empty row before footer
echo '<tr>';
for ($i = 0; $i < 8; $i++) {
    echo '<td class="data-cell" style="height: 5px;"></td>';
}
echo '</tr>';

// Footer - Total
echo '<tr>';
echo '<td colspan="7" class="footer" style="text-align:right;">TOTAL</td>';
echo '<td class="footer" style="text-align:right;">' . number_format($totalNilai, 0, ',', ',') . '</td>';
echo '</tr>';

echo '</table>';
echo '</body>';
echo '</html>';
exit;
?>