<?php
session_start();

// Validasi session - Manager only
if (!isset($_SESSION['login']) || $_SESSION['login'] !== true) {
    header("Location: ../../index.html?error=session");
    exit;
}

$userRole = strtoupper(trim($_SESSION['role'] ?? ''));
if ($userRole !== 'M') {
    header("Location: ../../index.html?error=forbidden");
    exit;
}

require_once __DIR__ . '/../../DataBase/koneksi.php';

// Get all inventory data
$sql = "SELECT * FROM inventory ORDER BY tanggal_perolehan ASC, id ASC";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error query: " . mysqli_error($conn));
}

// Calculate totals
$totalNilai = 0;
$dataLaporan = [];

while ($row = mysqli_fetch_assoc($result)) {
    $dataLaporan[] = $row;
    $totalNilai += $row['harga_perolehan'];
}

function formatRupiah($angka) {
    return 'Rp ' . number_format($angka, 0, ',', '.');
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Daftar Inventory - ACF Eduhub</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --acf-purple: #812D7E;
            --acf-purple-dark: #632261;
            --acf-yellow: #F4B840;
            --acf-gray: #f8fafc;
            --text-dark: #334155;
        }

        @media print {
            @page {
                size: A4 landscape;
                margin: 10mm;
            }
            body { padding: 0 !important; background: white !important; }
            .no-print { display: none !important; }
            .report-container { box-shadow: none !important; border: none !important; }
            th { background-color: var(--acf-purple) !important; color: white !important; -webkit-print-color-adjust: exact; }
            .footer-row { background-color: var(--acf-purple) !important; color: white !important; -webkit-print-color-adjust: exact; }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            font-size: 10pt;
            background: #e2e8f0;
            padding: 30px;
            color: var(--text-dark);
        }

        .report-container {
            background: white;
            max-width: 1200px;
            margin: 0 auto;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            border-top: 6px solid var(--acf-yellow);
        }

        /* Header Laporan */
        .header {
            background: white;
            padding: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #f1f5f9;
        }

        .brand h1 {
            color: var(--acf-purple);
            font-size: 20pt;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .brand p {
            color: #64748b;
            font-size: 10pt;
            margin-top: 5px;
        }

        /* Tabel Desain */
        .table-wrapper {
            padding: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            table-layout: fixed;
        }

        th {
            background: var(--acf-purple);
            color: white;
            padding: 12px 8px;
            border: 1px solid #632261;
            font-weight: 600;
            font-size: 9pt;
            text-transform: uppercase;
        }

        td {
            border: 1px solid #e2e8f0;
            padding: 10px 8px;
            vertical-align: middle;
            font-size: 9pt;
            word-wrap: break-word;
        }

        tr:nth-child(even) { background-color: #fcfcfc; }
        tr:hover td { background-color: #f8f5f9; }

        .number { text-align: center; font-weight: bold; color: var(--acf-purple); }
        .date { text-align: center; white-space: nowrap; color: #475569; }
        .currency { text-align: right; font-weight: 600; font-family: 'Consolas', monospace; }

        .footer-row {
            background: var(--acf-purple);
            color: white;
            font-weight: bold;
        }

        .footer-row td {
            padding: 15px 10px;
            border: none;
        }

        /* Tombol Navigasi */
        .no-print {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 25px;
            background: var(--acf-purple);
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: 0.3s;
            font-size: 14px;
        }

        .btn:hover { background: var(--acf-purple-dark); transform: translateY(-2px); }
        .btn-secondary { background: #64748b; }
        .btn-secondary:hover { background: #334155; }

        /* Meta Info */
        .meta-info {
            padding: 0 30px 20px;
            font-size: 8pt;
            color: #94a3b8;
            text-align: right;
        }
    </style>
</head>
<body>

<div class="no-print">
    <button onclick="window.print()" class="btn">
        <i class="fas fa-print"></i> Cetak / Simpan PDF
    </button>
    <button onclick="closePage()" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali
    </button>
</div>

<div class="report-container">
    <div class="header">
        <div class="brand">
            <h1>Daftar Inventory</h1>
            <p><i class="fas fa-university"></i> Yayasan ACF Eduhub - Sistem Informasi Aset</p>
        </div>
        <div style="text-align: right; color: var(--acf-purple)">
            <i class="fas fa-boxes-stacked fa-3x"></i>
        </div>
    </div>

    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 12%;">Tanggal</th>
                    <th style="width: 15%;">Kategori</th>
                    <th style="width: 15%;">Sumber Dana</th>
                    <th style="width: 13%;">Kantor</th>
                    <th style="width: 15%;">Jenis Barang</th>
                    <th>Detail Inventory</th>
                    <th style="width: 14%;">Harga (Rp)</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1;
                foreach ($dataLaporan as $row): 
                ?>
                <tr>
                    <td class="number"><?php echo $no++; ?></td>
                    <td class="date"><?php echo date('d M Y', strtotime($row['tanggal_perolehan'])); ?></td>
                    <td style="font-weight: 500;"><?php echo htmlspecialchars($row['kategori'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($row['sumber_dana'] ?? ''); ?></td>
                    <td><i class="fas fa-building" style="font-size: 8pt; color: #cbd5e1;"></i> <?php echo htmlspecialchars($row['kantor'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($row['jenis_barang'] ?? ''); ?></td>
                    <td style="font-size: 8.5pt; color: #64748b; font-style: italic;">
                        <?php echo htmlspecialchars($row['jenis_inventory'] ?? '-'); ?>
                    </td>
                    <td class="currency"><?php echo number_format($row['harga_perolehan'], 0, ',', '.'); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr class="footer-row">
                    <td colspan="7" style="text-align: right; text-transform: uppercase; letter-spacing: 1px;">Total Nilai Aset</td>
                    <td class="currency" style="font-size: 11pt; border-left: 1px solid rgba(255,255,255,0.2);">
                        <?php echo number_format($totalNilai, 0, ',', '.'); ?>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
    
    <div class="meta-info">
        Dicetak pada: <?php echo date('d/m/Y H:i'); ?> | Admin: <?php echo htmlspecialchars($_SESSION['role']); ?>
    </div>
</div>

<script>
function closePage() {
    if (window.opener) {
        window.close();
    } else {
        window.history.back();
    }
}

const urlParams = new URLSearchParams(window.location.search);
if (urlParams.get('auto') === 'print') {
    window.onload = function() {
        setTimeout(function() {
            window.print();
        }, 800);
    };
}
</script>

</body>
</html>