<?php
require_once __DIR__ . '/../../auth/auth_staff.php';
require_once __DIR__ . '/../../DataBase/koneksi.php';

// Cek koneksi database
if (!isset($conn) || $conn->connect_error) {
    die("Koneksi database gagal: " . ($conn->connect_error ?? 'Unknown error'));
}

$id = $_GET['id'] ?? 0;

// Query untuk mengambil detail barang dari tabel inventory
$query = "SELECT * FROM inventory WHERE id = ?";
$stmt = $conn->prepare($query);

if (!$stmt) {
    die("Error dalam query: " . $conn->error . "<br>Query: " . $query);
}

$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$barang = $result->fetch_assoc();

if (!$barang) {
    echo "<script>alert('Barang tidak ditemukan!'); window.location.href='inventory.php';</script>";
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Barang - <?= htmlspecialchars($barang['jenis_barang']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-8">
        <!-- Header -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <div class="flex justify-between items-center">
                <h1 class="text-3xl font-bold text-gray-800">Detail Barang</h1>
                <a href="inventory_list_staff.php" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg transition">
                    ← Kembali
                </a>
            </div>
        </div>

        <!-- Detail Barang -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Kolom Kiri -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">No. Barang</label>
                        <p class="text-lg font-semibold text-gray-800"><?= htmlspecialchars($barang['no']) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Jenis Barang</label>
                        <p class="text-lg font-semibold text-gray-800"><?= htmlspecialchars($barang['jenis_barang']) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Kategori</label>
                        <p class="text-lg text-gray-800">
                            <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                                <?= htmlspecialchars($barang['kategori']) ?>
                            </span>
                        </p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Kantor</label>
                        <p class="text-lg text-gray-800"><?= htmlspecialchars($barang['kantor']) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Tanggal Perolehan</label>
                        <p class="text-lg text-gray-800"><?= date('d F Y', strtotime($barang['tanggal_perolehan'])) ?></p>
                    </div>
                </div>

                <!-- Kolom Kanan -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Harga Perolehan</label>
                        <p class="text-2xl font-bold text-green-600">Rp <?= number_format($barang['harga_perolehan'], 0, ',', '.') ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Sumber Dana</label>
                        <p class="text-lg text-gray-800">
                            <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-medium">
                                <?= htmlspecialchars($barang['sumber_dana']) ?>
                            </span>
                        </p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Tanggal Ditambahkan</label>
                        <p class="text-lg text-gray-800"><?= date('d/m/Y H:i', strtotime($barang['created_at'])) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-1">Terakhir Diupdate</label>
                        <p class="text-lg text-gray-800"><?= date('d/m/Y H:i', strtotime($barang['updated_at'])) ?></p>
                    </div>
                </div>
            </div>

            <!-- Jenis Inventory (Deskripsi) -->
            <?php if (!empty($barang['jenis_inventory'])): ?>
            <div class="mt-6 pt-6 border-t border-gray-200">
                <label class="block text-sm font-medium text-gray-600 mb-2">Deskripsi / Jenis Inventory</label>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-gray-800 leading-relaxed"><?= nl2br(htmlspecialchars($barang['jenis_inventory'])) ?></p>
                </div>
            </div>
            <?php endif; ?>

            <!-- Ringkasan Informasi -->
            <div class="mt-6 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Ringkasan Informasi</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-blue-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">ID Barang</p>
                        <p class="text-2xl font-bold text-blue-600">#<?= $barang['id'] ?></p>
                    </div>
                    
                    <div class="bg-green-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Nilai Perolehan</p>
                        <p class="text-xl font-bold text-green-600">Rp <?= number_format($barang['harga_perolehan'], 0, ',', '.') ?></p>
                    </div>
                    
                    <div class="bg-purple-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-1">Umur Aset</p>
                        <p class="text-xl font-bold text-purple-600">
                            <?php
                            $tanggal_perolehan = new DateTime($barang['tanggal_perolehan']);
                            $sekarang = new DateTime();
                            $selisih = $tanggal_perolehan->diff($sekarang);
                            
                            if ($selisih->y > 0) {
                                echo $selisih->y . ' tahun ' . $selisih->m . ' bulan';
                            } elseif ($selisih->m > 0) {
                                echo $selisih->m . ' bulan ' . $selisih->d . ' hari';
                            } else {
                                echo $selisih->d . ' hari';
                            }
                            ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Timeline -->
            <div class="mt-6 pt-6 border-t border-gray-200">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Timeline</h3>
                <div class="space-y-3">
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-800">Tanggal Perolehan</p>
                            <p class="text-xs text-gray-600"><?= date('d F Y', strtotime($barang['tanggal_perolehan'])) ?></p>
                        </div>
                    </div>
                    
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-2 h-2 bg-green-500 rounded-full mt-2 mr-3"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-800">Ditambahkan ke Sistem</p>
                            <p class="text-xs text-gray-600"><?= date('d F Y, H:i', strtotime($barang['created_at'])) ?></p>
                        </div>
                    </div>
                    
                    <div class="flex items-start">
                        <div class="flex-shrink-0 w-2 h-2 bg-yellow-500 rounded-full mt-2 mr-3"></div>
                        <div>
                            <p class="text-sm font-medium text-gray-800">Terakhir Diupdate</p>
                            <p class="text-xs text-gray-600"><?= date('d F Y, H:i', strtotime($barang['updated_at'])) ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>