<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <style>
        :root {
            --primary: #8B4789;
            --primary-light: #8B478910;
            --secondary: #F4B840;
            --text-dark: #1e293b;
            --border: #e2e8f0;
            --bg-card: #ffffff;
        }

        .detail-container {
            max-width: 600px;
            background: var(--bg-card);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            font-family: 'Inter', sans-serif;
        }

        /* Header Detail */
        .detail-header {
            background: var(--primary);
            color: white;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .detail-header h3 {
            margin: 0;
            font-size: 1.2rem;
            letter-spacing: 0.5px;
        }

        /* Label Status di Header */
        .status-pill {
            background: var(--secondary);
            color: #000;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
        }

        /* Body Detail */
        .detail-body {
            padding: 0;
        }

        .info-row {
            display: flex;
            border-bottom: 1px solid var(--border);
            transition: background 0.2s;
        }

        .info-row:last-child { border-bottom: none; }
        .info-row:hover { background: var(--primary-light); }

        .info-label {
            width: 35%;
            padding: 15px 20px;
            background: #fcfcfc;
            color: var(--text-dark);
            font-weight: 600;
            font-size: 0.85rem;
            border-right: 1px solid var(--border);
        }

        .info-value {
            width: 65%;
            padding: 15px 20px;
            color: #475569;
            font-size: 0.9rem;
        }

        /* Highlight untuk No Aset */
        .no-aset {
            color: var(--primary);
            font-weight: 700;
        }

        .footer-action {
            padding: 15px 20px;
            text-align: right;
            background: #f8fafc;
        }

        .btn-close {
            background: #64748b;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
        }
    </style>
</head>
<body>

<div class="detail-container">
    <div class="detail-header">
        <div>
            <h3>Detail Aset</h3>
            <small id="display-nama-barang">Memuat...</small>
        </div>
        <span class="status-pill" id="display-status">-</span>
    </div>

    <div class="detail-body">
        <div class="info-row">
            <div class="info-label">No. Inventaris</div>
            <div class="info-value no-aset" id="display-no">-</div>
        </div>
        <div class="info-row">
            <div class="info-label">Kategori</div>
            <div class="info-value" id="display-kategori">-</div>
        </div>
        <div class="info-row">
            <div class="info-label">Merek / Spesifikasi</div>
            <div class="info-value" id="display-merek">-</div>
        </div>
        <div class="info-row">
            <div class="info-label">Lokasi Kantor</div>
            <div class="info-value" id="display-kantor">-</div>
        </div>
        <div class="info-row">
            <div class="info-label">Tanggal Masuk</div>
            <div class="info-value" id="display-tgl">-</div>
        </div>
        <div class="info-row">
            <div class="info-label">Keterangan</div>
            <div class="info-value" id="display-keterangan">-</div>
        </div>
    </div>

    <div class="footer-action">
        <button class="btn-close" onclick="window.history.back()">Kembali</button>
    </div>
</div>

<script>
// Contoh cara memanggil file PHP Anda menggunakan Fetch API
async function loadDetail(id) {
    try {
        const response = await fetch(`get_detail.php?id=${id}`);
        const result = await response.json();

        if(result.success) {
            const d = result.data;
            document.getElementById('display-no').innerText = d.no;
            document.getElementById('display-nama-barang').innerText = d.jenis_barang;
            document.getElementById('display-kategori').innerText = d.kategori;
            document.getElementById('display-merek').innerText = d.merek || '-';
            document.getElementById('display-kantor').innerText = d.kantor;
            document.getElementById('display-status').innerText = d.status_label;
            document.getElementById('display-tgl').innerText = d.tanggal_masuk;
            document.getElementById('display-keterangan').innerText = d.keterangan || '-';
        }
    } catch (error) {
        console.error("Gagal memuat data", error);
    }
}

// Panggil fungsi ini dengan ID yang diinginkan (misal dari URL)
// loadDetail(5); 
</script>

</body>
</html>