<?php
/**
 * TEST PATHS - Debugging Tool
 * Letakkan file ini di folder 'pages/' atau 'pages/staff/'
 * Akses via browser untuk cek struktur folder
 */

echo "<!DOCTYPE html>
<html lang='id'>
<head>
    <meta charset='UTF-8'>
    <title>Path Checker - ACF</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #1e293b; color: #fff; }
        .container { background: #334155; padding: 30px; border-radius: 10px; max-width: 900px; margin: 0 auto; }
        h1 { color: #8B4789; margin-bottom: 20px; }
        .section { background: #1e293b; padding: 15px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #8B4789; }
        .ok { color: #10b981; }
        .error { color: #ef4444; }
        .path { background: #0f172a; padding: 8px 12px; border-radius: 5px; margin: 5px 0; display: block; }
        .info { color: #60a5fa; }
        table { width: 100%; margin-top: 10px; border-collapse: collapse; }
        td { padding: 8px; border-bottom: 1px solid #475569; }
        td:first-child { color: #94a3b8; font-weight: bold; width: 200px; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🔍 ACF Inventory - Path Checker</h1>
";

// Current file info
echo "<div class='section'>
    <h3 class='info'>📍 Current File Location</h3>
    <table>
        <tr><td>Current File:</td><td class='path'>" . __FILE__ . "</td></tr>
        <tr><td>Current Dir:</td><td class='path'>" . __DIR__ . "</td></tr>
        <tr><td>Parent Dir:</td><td class='path'>" . dirname(__DIR__) . "</td></tr>
    </table>
</div>";

// Check files existence
$files_to_check = [
    'Database Connection' => __DIR__ . '/../DataBase/koneksi.php',
    'Panel Cetak Label' => __DIR__ . '/cetak_label_panel.php',
    'Cetak Massal' => __DIR__ . '/cetak_label_massal.php',
    'Inventory List Staff' => __DIR__ . '/staff/inventory_list_staff.php',
    'Home Staff' => __DIR__ . '/staff/home_staff.php',
];

// If in staff folder, adjust paths
if (basename(__DIR__) === 'staff') {
    $files_to_check = [
        'Database Connection' => __DIR__ . '/../../DataBase/koneksi.php',
        'Panel Cetak Label' => __DIR__ . '/../cetak_label_panel.php',
        'Cetak Massal' => __DIR__ . '/../cetak_label_massal.php',
        'Inventory List Staff' => __DIR__ . '/inventory_list_staff.php',
        'Home Staff' => __DIR__ . '/home_staff.php',
    ];
}

echo "<div class='section'>
    <h3 class='info'>📂 Files Check</h3>
    <table>";

foreach ($files_to_check as $label => $path) {
    $exists = file_exists($path);
    $status = $exists ? "<span class='ok'>✓ EXISTS</span>" : "<span class='error'>✗ NOT FOUND</span>";
    echo "<tr>
        <td>$label:</td>
        <td>$status<br><span class='path' style='font-size:11px;'>$path</span></td>
    </tr>";
}

echo "</table></div>";

// Folder structure recommendation
echo "<div class='section'>
    <h3 class='info'>📁 Recommended Folder Structure</h3>
    <pre style='color:#10b981; font-size:12px; line-height:1.8;'>
inventory_acf/
├── DataBase/
│   └── koneksi.php
├── pages/
│   ├── cetak_label_panel.php
│   ├── cetak_label_massal.php
│   ├── config_paths.php (optional helper)
│   └── staff/
│       ├── home_staff.php
│       └── inventory_list_staff.php
└── index.html
    </pre>
</div>";

// Path recommendations
echo "<div class='section'>
    <h3 class='info'>🔗 Correct Path Usage</h3>
    <table>
        <tr>
            <td>From pages/ to staff/:</td>
            <td><code class='path'>./staff/inventory_list_staff.php</code></td>
        </tr>
        <tr>
            <td>From staff/ to pages/:</td>
            <td><code class='path'>../cetak_label_panel.php</code></td>
        </tr>
        <tr>
            <td>From pages/ to DataBase/:</td>
            <td><code class='path'>../DataBase/koneksi.php</code></td>
        </tr>
        <tr>
            <td>From staff/ to DataBase/:</td>
            <td><code class='path'>../../DataBase/koneksi.php</code></td>
        </tr>
    </table>
</div>";

// Server info
echo "<div class='section'>
    <h3 class='info'>🖥️ Server Information</h3>
    <table>
        <tr><td>PHP Version:</td><td>" . phpversion() . "</td></tr>
        <tr><td>Server Software:</td><td>" . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "</td></tr>
        <tr><td>Document Root:</td><td class='path'>" . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "</td></tr>
        <tr><td>Script Name:</td><td class='path'>" . ($_SERVER['SCRIPT_NAME'] ?? 'Unknown') . "</td></tr>
    </table>
</div>";

echo "
    </div>
    <div style='text-align:center; margin-top:20px; color:#64748b;'>
        <p>✅ If all files show EXISTS, your paths are correct!</p>
        <p>❌ If files NOT FOUND, adjust your folder structure</p>
    </div>
</body>
</html>";
?>