<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Cek apakah user sudah login
if (!isset($_SESSION["user_type"])) {
    header("Location: pages/login_proc.php");
    exit;
}

$userType = $_SESSION["user_type"];
$userName = $_SESSION["nama"] ?? "User";

// ✅ TENTUKAN ROLE LABEL DAN DEFAULT PAGE
$roleLabel = "User";
$dashboardTitle = "Dashboard";
$defaultPage = "pages/welcome.php"; // Default fallback

if ($userType === "S") {
    $roleLabel = "Staff Gudang";
    $dashboardTitle = "Dashboard Staff Gudang";
    $defaultPage = "pages/Staff/home_staff.php";
} elseif ($userType === "M") {
    $roleLabel = "Manager";
    $dashboardTitle = "Dashboard Manager";
    $defaultPage = "pages/Manager/home_manager.php";
} elseif ($userType === "A") {
    $roleLabel = "Administrator";
    $dashboardTitle = "Dashboard Admin";
    $defaultPage = "pages/Admin/home_admin.php";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard Inventory ACF</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: Arial, sans-serif;
            overflow: hidden;
        }
        .container {
            display: flex;
            height: 100vh;
        }
        .sidebar {
            width: 250px;
            background: #1e3a8a;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
        }
        .user-info {
            padding: 20px;
            background: #1e40af;
            color: white;
            text-align: center;
            border-bottom: 2px solid #3b82f6;
        }
        .user-info h2 {
            font-size: 18px;
            margin-bottom: 5px;
        }
        .user-info p {
            font-size: 12px;
            color: #bfdbfe;
        }
        .menu-container {
            flex: 1;
            overflow-y: auto;
        }
        .logout-btn {
            padding: 15px;
            background: #dc2626;
            color: white;
            text-align: center;
            text-decoration: none;
            display: block;
            font-weight: bold;
            transition: 0.3s;
            cursor: pointer;
        }
        .logout-btn:hover {
            background: #b91c1c;
        }
        .content {
            flex: 1;
            background: #f8fafc;
            overflow-y: auto;
        }
        iframe {
            width: 100%;
            height: 100%;
            border: none;
        }
        .header {
            background: white;
            padding: 15px 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            color: #1e3a8a;
            font-size: 24px;
        }
        .header-info {
            color: #64748b;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Sidebar -->
        <div class="sidebar">
            <!-- User Info -->
            <div class="user-info">
                <h2><?php echo htmlspecialchars($userName); ?></h2>
                <p>● <?php echo htmlspecialchars($roleLabel); ?></p>
            </div>

            <!-- Menu Container -->
            <div class="menu-container">
                <?php
                if ($userType === "S") {
                    include 'pages/Staff/menu_staff.php';
                } elseif ($userType === "M") {
                    include 'pages/Manager/menu_manager.php';
                } elseif ($userType === "A") {
                    include 'pages/Admin/menu_admin.php';
                }
                ?>
            </div>

            <!-- Logout Button -->
            <a href="logout.php" class="logout-btn">🚪 Keluar</a>
        </div>

        <!-- Content Area -->
        <div class="content">
            <div class="header">
                <h1>Sistem Aset Inventory ACF</h1>
                <div class="header-info"><?php echo htmlspecialchars($dashboardTitle); ?></div>
            </div>
            <!-- ✅ PERBAIKAN - src dinamis sesuai role -->
            <iframe name="content" src="<?php echo $defaultPage; ?>"></iframe>
        </div>
    </div>
</body>
</html>